<?php

namespace App\Modules\GroupProvider\Application\ListGallery;

use App\Modules\Shared\Domain\Bus\Query\Query;
use App\Modules\Shared\Domain\DateEnd;
use App\Modules\Shared\Domain\DateStart;

final class ListGalleryGroupProviderQuery implements Query
{
    public function __construct(
        private DateStart $dateStart,
        private DateEnd $dateEnd,
        private string $search,
        private string $action,
        private ?string $page,
        private ?string $pageSize,
    ) {
    }

    public function dateStart(): DateStart
    {
        return $this->dateStart;
    }

    public function dateEnd(): DateEnd
    {
        return $this->dateEnd;
    }

    public function search(): string
    {
        return $this->search;
    }

    public function action(): string
    {
        return $this->action;
    }

    public function page(): ?string
    {
        return $this->page;
    }
    public function pageSize(): ?string
    {
        return $this->pageSize;
    }
}
