<?php

namespace App\Modules\GroupProvider\Application\List;

use App\Modules\Group\Domain\IdGroup;
use App\Modules\GroupProvider\Application\GroupProviderResponse;
use App\Modules\GroupProvider\Application\GroupProviderResponses;
use App\Modules\GroupProvider\Domain\GroupProvider;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;

final class ListGroupProviderQueryHandler implements QueryHandler
{
    public function __construct(private GroupProviderLister $list)
    {
    }

    public function __invoke(ListGroupProviderQuery $query): GroupProviderResponses
    {
        return new GroupProviderResponses(...array_map(
            fn (GroupProvider $provider) => new GroupProviderResponse(
                $provider->id()->value(),
                $provider->type()->value(),
                $provider->remark()->value(),
                $provider->answeredReview()->value(),
                $provider->mask()->value(),
                $provider->isCloned()->value(),
                $provider->mediaStatus()->value(),
                $provider->mediaScore()->value(),
                $provider->idGroup()->value(),
                $provider->idProvider()->value(),
                $provider->idTypeProvider()->value(),
                $provider->idStatusGroupProvider()->value(),
            ),
            $this->list->__invoke(new IdGroup($query->idGroup()))
        ));
    }
}
