<?php

namespace App\Modules\GroupProvider\Application;

use App\Modules\Group\Domain\IdGroup;
use App\Modules\GroupProvider\Domain\GroupProviderRepository;
use App\Modules\Provider\Domain\ProviderNoDocument;

class GroupProviderDocumentSearcher
{
    private GroupProviderRepository $repository;

    public function __construct(GroupProviderRepository $repository)
    {
        $this->repository = $repository;
    }

    public function __invoke(IdGroup $idGroup)
    {
        return function (ProviderNoDocument $noDocument) use ($idGroup) {
            return $this->repository->searchByDocument($idGroup, $noDocument);
        };
    }
}
