<?php

namespace App\Modules\GroupProvider\Application\DownloadMedia;

use App\Modules\GroupProvider\Domain\IdGroupProvider;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;

final class DownloadMediaGroupProviderQueryHandler implements QueryHandler
{
    public function __construct(
        private GroupProviderMediaDownloader $downloader
    ) {
    }

    public function __invoke(DownloadMediaGroupProviderQuery $query): DownloadMediaGroupProviderResponse
    {
        $response = $this->downloader->__invoke(new IdGroupProvider($query->id()));
        return new DownloadMediaGroupProviderResponse($response);
    }
}
