<?php

namespace App\Modules\GroupPassengerMedia\Application\Index;

use App\Modules\GroupPassengerMedia\Application\GroupPassengerMediaResponse;
use App\Modules\GroupPassengerMedia\Domain\IdGroupPassengerMedia;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;

final class IndexGroupPassengerMediaQueryHandler implements QueryHandler
{
    public function __construct(private GroupPassengerMediaIndexer $inserter)
    {
    }

    public function __invoke(IndexGroupPassengerMediaQuery $query): GroupPassengerMediaResponse
    {
        $model = $this->inserter->__invoke(new IdGroupPassengerMedia($query->getId()));
        return new GroupPassengerMediaResponse(
            $model->id()->value(),
            $model->path()->value(),
            $model->pathThumb()->value(),
            $model->pathLargeThumb()->value(),
            $model->description()->value(),
            $model->extension()->value(),
            $model->size()->value(),
            $model->type()->value(),
            $model->hasThumbnail()->value(),
            $model->error()->value(),
            $model->status()->value(),
            $model->idGroupPassenger()->value(),
        );
    }
}
