<?php

namespace App\Modules\GroupPassengerMedia\Application\Create;

use App\Modules\GroupPassenger\Domain\IdGroupPassenger;
use App\Modules\GroupPassengerMedia\Domain\IdGroupPassengerMedia;
use App\Modules\GroupPassengerMedia\Domain\GroupPassengerMedia;
use App\Modules\GroupPassengerMedia\Domain\GroupPassengerMediaDescription;
use App\Modules\GroupPassengerMedia\Domain\GroupPassengerMediaError;
use App\Modules\GroupPassengerMedia\Domain\GroupPassengerMediaExtension;
use App\Modules\GroupPassengerMedia\Domain\GroupPassengerMediaHasThumbnail;
use App\Modules\GroupPassengerMedia\Domain\GroupPassengerMediaPath;
use App\Modules\GroupPassengerMedia\Domain\GroupPassengerMediaPathLargeThumb;
use App\Modules\GroupPassengerMedia\Domain\GroupPassengerMediaPathThumb;
use App\Modules\GroupPassengerMedia\Domain\GroupPassengerMediaSize;
use App\Modules\GroupPassengerMedia\Domain\GroupPassengerMediaStatus;
use App\Modules\GroupPassengerMedia\Domain\GroupPassengerMediaType;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;

final class CreateGroupPassengerMediaQueryHandler implements QueryHandler
{
    public function __construct(private GroupPassengerMediaCreator $creator)
    {
    }

    public function __invoke(CreateGroupPassengerMediaQuery $query): CreateGroupPassengerMediaResponse
    {
        $model = new GroupPassengerMedia(
            new IdGroupPassengerMedia(0),
            new GroupPassengerMediaPath($query->path()),
            new GroupPassengerMediaPathThumb($query->pathThumb()),
            new GroupPassengerMediaPathLargeThumb($query->pathLargeThumb()),
            new GroupPassengerMediaDescription($query->description()),
            new GroupPassengerMediaExtension($query->extension()),
            new GroupPassengerMediaSize($query->size()),
            new GroupPassengerMediaType($query->type()),
            new GroupPassengerMediaHasThumbnail($query->hasThumbnail()),
            new GroupPassengerMediaError($query->error()),
            new GroupPassengerMediaStatus($query->status()),
            new IdGroupPassenger($query->idGroupPassenger()),
        );
        return new CreateGroupPassengerMediaResponse($this->creator->__invoke($model));
    }
}
