<?php

namespace App\Modules\GroupPassenger\Application\UpdateMediaScore;

use App\Modules\GroupPassenger\Domain\GroupPassengerMediaScore;
use App\Modules\GroupPassenger\Domain\IdGroupPassenger;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;

final class UpdateMediaScoreGroupPassengerQueryHandler implements QueryHandler
{
    public function __construct(
        private MediaScoreGroupPassengerUpdater $reviewer
    ) {
    }

    public function __invoke(UpdateMediaScoreGroupPassengerQuery $query): UpdateMediaScoreGroupPassengerResponse
    {
        $this->reviewer->__invoke(
            new IdGroupPassenger($query->id()),
            new GroupPassengerMediaScore($query->mediaScore())
        );
        return new UpdateMediaScoreGroupPassengerResponse();
    }
}
