<?php

namespace App\Modules\GroupPassenger\Application\ReportCategorized;

use App\Modules\Group\Domain\GroupDateEnd;
use App\Modules\Group\Domain\GroupDateStart;
use App\Modules\GroupPassenger\Domain\GroupPassengerReportRepository;

final class GroupPassengerCategorizedReporter
{
    public function __construct(private GroupPassengerReportRepository $repository)
    {
    }

    public function __invoke(
        GroupDateStart $dateStart,
        GroupDateEnd $dateEnd
    ): ReportCategorizedGroupPassengerResponse {
        return new ReportCategorizedGroupPassengerResponse($this->repository->reportCategorized($dateStart, $dateEnd));
    }
}
