<?php

namespace App\Modules\GroupPassenger\Application\Report;

use App\Modules\Group\Domain\GroupDateEnd;
use App\Modules\Group\Domain\GroupDateStart;
use App\Modules\GroupPassenger\Domain\GroupPassengerReportRepository;

final class GroupPassengerReporter
{
    public function __construct(private GroupPassengerReportRepository $repository)
    {
    }

    public function __invoke(
        GroupDateStart $dateStart,
        GroupDateEnd $dateEnd
    ): ReportGroupPassengerResponse {
        return new ReportGroupPassengerResponse($this->repository->report($dateStart, $dateEnd));
    }
}
