<?php

namespace App\Modules\GroupPassenger\Application\Index;

use App\Modules\GroupPassenger\Domain\IdGroupPassenger;
use App\Modules\GroupPassenger\Domain\GroupPassengerRepository;
use App\Modules\GroupPassenger\Domain\IndexGroupPassenger;

final class GroupPassengerIndexer
{
    public function __construct(private GroupPassengerRepository $repository)
    {
    }

    public function __invoke(IdGroupPassenger $id)
    {
        return $this->repository->find(new IndexGroupPassenger($id));
    }
}
