<?php

namespace App\Modules\Group\Infraestructure;

use App\Modules\CategoryTour\Domain\IdCategoryTour;
use App\Modules\Group\Domain\Group;
use App\Modules\Group\Domain\GroupRepositoryAlter;
use App\Modules\Group\Domain\IdGroup;
use App\Modules\Shared\Domain\DateEnd;
use App\Modules\Shared\Domain\DateStart;
use App\Modules\Shared\Infraestructure\DBRequester;
use App\Modules\Shared\Infraestructure\RequestChecker;
use App\Modules\Shared\Infraestructure\Requester;
use App\Modules\StatusGroup\Domain\IdStatusGroup;
use App\Modules\Tour\Domain\IdTour;
use Illuminate\Support\Facades\DB;

class MysqlGroupRepositoryAlter implements GroupRepositoryAlter
{
    public function list(
        string $action,
        IdCategoryTour $idCategoryTour,
        IdTour $idTour,
        DateStart $dateStart,
        DateEnd $dateEnd,
        string $token
    ) {
        return RequestChecker::requestSelect(
            'CALL sp_group_list_alter(?,?,?,?,?,@sts,@cod,@msg)',
            [
                $action,
                $idCategoryTour->value(),
                $idTour->value(),
                $dateStart->value(),
                $dateEnd->value()
            ]
        );
    }

    public function copyProviders(IdGroup $idGroup)
    {
        $copy = RequestChecker::requestUpdate(
            'CALL sp_group_copy_providers(?,@sts,@cod,@msg)',
            [$idGroup->value()]
        );

        $group = DB::select('CALL sp_group_index(?)', [$idGroup->value()])[0];

        $groupProviders = DB::select('CALL sp_group_provider_list(?)', [$idGroup->value()]);
        if ($group->Group_Status !== 2) {
            return $copy;
        }
        $questionList = $this->getQuestionList($group->Id_Service);

        foreach ($groupProviders as $gp) {
            if ($gp->GroupProvider_AnsweredReview !== 0) {
                continue;
            }
            DB::select('CALL sp_internal_group_provider_add_review(?,@sts,@cod,@msg)', [$gp->Id_GroupProvider]);

            foreach ($questionList as $question) {
                if (!$this->questionTypeProviderAvailableFor($question->QuestionTypeProvider, 1, $gp->Id_TypeProvider)) {
                    continue;
                }
                Requester::requestInsert(
                    'CALL sp_group_provider_review_insert(?,?,@sts,@cod,@msg,@id)',
                    [$gp->Id_GroupProvider, $question->Id_Question]
                );
            }
            DB::select('UPDATE `t_group_provider` SET `GroupProvider_AnsweredReview` = 1 WHERE `Id_GroupProvider` = ?', [$gp->Id_GroupProvider]);
        }

        return $copy;
    }

    public function updateStatus(IdGroup $idGroup, IdStatusGroup $idStatusGroup)
    {
        $copy = RequestChecker::requestUpdate(
            'CALL sp_group_update_status(?,?,@sts,@cod,@msg)',
            [$idGroup->value(), $idStatusGroup->value()]
        );
        return $copy;
    }

    public function updateDateUpdate(IdGroup $idGroup)
    {
        $copy = RequestChecker::requestUpdate(
            'CALL sp_group_update_date_update(?,@sts,@cod,@msg)',
            [$idGroup->value()]
        );
        return $copy;
    }

    private function getQuestionList($idTour)
    {
        return array_map(
            function ($tql) {
                $tql->QuestionTypeProvider = json_decode($tql->QuestionTypeProviderJSON);
                return $tql;
            },
            DB::select('call sp_tour_question_list(?)', [$idTour])
        );
    }

    private function questionTypeProviderAvailableFor(array $questionTypeProviderList, int $questionTypeProviderForPassenger, int $idTypeProvider)
    {
        $show = true;
        foreach ($questionTypeProviderList as $qtp) {
            if ($qtp->QuestionTypeProvider_ForPassenger != $questionTypeProviderForPassenger) {
                continue;
            }

            if ($idTypeProvider == 0) {
                if ($idTypeProvider == $qtp->Id_TypeProvider) {
                    $show = $qtp->QuestionTypeProvider_Show == 2;
                    break;
                } else {
                    $show = true;
                    break;
                }
            } else {
                if ($qtp->Id_TypeProvider == 0) {
                    $show = $qtp->QuestionTypeProvider_Show == 2;
                } else {
                    if ($qtp->Id_TypeProvider == $idTypeProvider) {
                        $show = $qtp->QuestionTypeProvider_Show == 2;
                        break;
                    }
                }
            }
        }
        return $show;
    }

    public function insert(Group $value)
    {
        return DBRequester::requestInsert($value);
    }
}
