<?php

namespace App\Modules\Group\Application;

use App\Modules\Group\Domain\GroupToken;
use App\Modules\Group\Domain\UnsafeCrypto;
use App\Modules\Shared\Exceptions\InvalidRequestException;
use Throwable;

class GroupTokenDecrypter
{

    public function __construct()
    {
    }

    public function __invoke(GroupToken $groupToken)
    {
        $key = 'asdljasljdasdiaosjdiqwjd';
        try {
            $id = UnsafeCrypto::decrypt(base64_decode($groupToken->getValue()), $key);
            if (!filter_var($id, FILTER_VALIDATE_INT)) {
                $this->throwException();
            }
        } catch (Throwable $ex) {
            $this->throwException();
        }
        return $id;
    }

    public function throwException()
    {
        throw new InvalidRequestException([
            "Response_Status"            => 406,
            "Response_Code"                => 406,
            "Response_Domain"            => 'global',
            "Response_Message"            => 'Not a valid Group Token',
            "Response_Data"                => NULL,
            "Response_Error_Message"    => 'Not a valid Group Token',
            "Response_Error_Reason"        => 'Not a valid Group Token',
        ]);
    }
}
