<?php

namespace App\Modules\Group\Application\FillGroupProviderReview;

use App\Modules\Group\Domain\GroupNotFound;
use App\Modules\Group\Domain\GroupRepository;
use App\Modules\Group\Domain\IdGroup;
use App\Modules\GroupProvider\Application\GroupProviderResponses;
use App\Modules\GroupProvider\Application\List\ListGroupProviderQuery;
use App\Modules\GroupProviderReview\Application\Create\GroupProviderReviewInserterQuery;
use App\Modules\Shared\Domain\Bus\Query\QueryBus;
use App\Modules\TourQuestion\Application\List\ListTourQuestionQuery;
use App\Modules\TourQuestion\Application\TourQuestionResponses;
use Illuminate\Support\Facades\DB;

final class GroupProviderReviewFiller
{
    public function __construct(
        private QueryBus $queryBus,
        private GroupRepository $groupRepository
    ) {
    }

    public function __invoke(
        IdGroup $idGroup
    ) {
        $index = $this->groupRepository->index($idGroup);
        if (!count($index)) {
            throw new GroupNotFound();
        }

        if ($index[0]->Group_Status != 2 && $index[0]->Group_Status != 3) {
            return;
        }
        /** @var GroupProviderResponses $gpResponse */
        $gpResponse = $this->queryBus->ask(new ListGroupProviderQuery($idGroup->value()));
        $groupProviderList = $gpResponse->data();
        /** @var TourQuestionResponses $tqResponse */
        $tqResponse = $this->queryBus->ask(new ListTourQuestionQuery($index[0]->Id_Tour));
        $questionList = $tqResponse->data();

        foreach ($groupProviderList as $groupProvider) {
            if ($groupProvider->GroupProvider_AnsweredReview == 1 || $groupProvider->GroupProvider_AnsweredReview == 2) {
                continue;
            }
            foreach ($questionList as $question) {
                if (!$this->questionTypeProviderAvailableFor($question->QuestionTypeProvider, 1, $groupProvider)) {
                    continue;
                }
                $this->queryBus->ask(
                    new GroupProviderReviewInserterQuery(
                        $groupProvider->Id_GroupProvider,
                        $question->Id_Question
                    )
                );
            }
        }

        DB::select(
            'UPDATE `t_group_provider`
            SET `GroupProvider_AnsweredReview` = 1
            WHERE `Id_Group` = ?
            AND `GroupProvider_AnsweredReview` = 0',
            [$idGroup->value()]
        );
    }

    private function questionTypeProviderAvailableFor(
        array $questionTypeProviderList,
        int $questionTypeProviderForPassenger,
        $groupProvider
    ) {
        $show = true;
        foreach ($questionTypeProviderList as $qtp) {
            if ($qtp->QuestionTypeProvider_ForPassenger != $questionTypeProviderForPassenger) {
                continue;
            }

            if ($groupProvider->Id_TypeProvider == 0) {
                if ($groupProvider->Id_TypeProvider == $qtp->Id_TypeProvider) {
                    $show = $qtp->QuestionTypeProvider_Show == 2;
                    break;
                } else {
                    $show = true;
                    break;
                }
            } else {
                if ($qtp->Id_TypeProvider == 0) {
                    $show = $qtp->QuestionTypeProvider_Show == 2;
                } else {
                    if ($qtp->Id_TypeProvider == $groupProvider->Id_TypeProvider) {
                        $show = $qtp->QuestionTypeProvider_Show == 2;
                        break;
                    }
                }
            }
        }
        return $show;
    }
}
