<?php

namespace App\Modules\Group\Application\Create;

use App\Modules\Group\Domain\CreateGroup;
use App\Modules\Group\Domain\GroupRepository;

final class GroupCreator
{
    public function __construct(private GroupRepository $repository)
    {
    }

    public function __invoke(CreateGroup $group): CreateGroupResponse
    {
        return new CreateGroupResponse($this->repository->insert($group));
    }
}
