<?php

namespace App\Modules\FactUnit\Infraestructure;

use App\Modules\FactUnit\Domain\FactUnit;
use App\Modules\FactUnit\Domain\FactUnitRepository;
use App\Modules\FactUnit\Domain\IdFactUnit;
use App\Modules\Shared\Domain\Storage\Criteria\StorageCriteria;
use App\Modules\Shared\Infraestructure\Requester;

class MysqlFactUnitRepository implements FactUnitRepository
{

    public function find(StorageCriteria $criteria): FactUnit
    {
        return FactUnit::fromDTO($criteria->run());
    }

    public function search(StorageCriteria $criteria): array
    {
        return array_map(fn($btp) => FactUnit::fromDTO($btp), $criteria->run());
    }

    public function insert(FactUnit $value)
    {
        return Requester::requestInsert(
            'CALL sp_fact_unit_insert(?,?,?,@sts,@cod,@msg,@id)',
            [
                $value->name()->value(),
                $value->abrv()->value(),
                $value->status()->value()
            ]
        );
    }

    public function update(FactUnit $value)
    {
        return Requester::requestUpdate(
            'CALL sp_fact_unit_update(?,?,?,?,@sts,@cod,@msg)',
            [
                $value->id()->value(),
                $value->name()->value(),
                $value->abrv()->value(),
                $value->status()->value(),
            ]
        );
    }
}
