<?php

namespace App\Modules\FactUnit\Application\Index;

use App\Modules\FactUnit\Application\FactUnitResponse;
use App\Modules\FactUnit\Domain\IdFactUnit;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;

final class FactUnitIndexerQueryHandler implements QueryHandler
{
    public function __construct(private FactUnitIndexer $inserter)
    {
    }

    public function __invoke(FactUnitIndexerQuery $query): FactUnitResponse
    {
        $model = $this->inserter->__invoke(new IdFactUnit($query->getId()));
        return new FactUnitResponse(
            $model->id()->value(),
            $model->name()->value(),
            $model->abrv()->value(),
            $model->status()->value(),
        );
    }
}
