<?php

namespace App\Modules\FactTypeReceipt\Domain;

use App\Modules\Shared\Domain\Storage\Criteria\StorageCriteria;
use Illuminate\Support\Facades\DB;

class IndexFactTypeReceipt implements StorageCriteria
{

    public function __construct(
        private IdFactTypeReceipt $id
    ) {
    }

    public function run()
    {
        return $this->analize($this->query());
    }

    protected function query()
    {
        $select = FactTypeReceipt::select('`ftd`');
        return DB::select(
            "SELECT $select
            FROM `t_fact_type_receipt` `ftd`
            WHERE `ftd`.`Id_FactTypeReceipt` = ?",
            [
                $this->id->value()
            ]
        );
    }

    protected function analize($data)
    {
        if (!count($data)) {
            throw new FactTypeReceiptNotFound();
        }
        return $data[0];
    }
}
