<?php

namespace App\Modules\FactTypeOperation\Domain;

use App\Modules\Shared\Domain\Storage\Criteria\StorageCriteria;
use Illuminate\Support\Facades\DB;

class ListFactTypeOperation implements StorageCriteria
{

    public function __construct(private string $action) {
    }

    public function run()
    {
        return $this->analize($this->query());
    }

    protected function query()
    {
        $select = FactTypeOperation::select('`ftd`');
        if ($this->action == 'all') {
            $where = '`ftd`.`FactTypeOperation_Status` IN (1, 2)';
        } else if ($this->action == 'active') {
            $where = '`ftd`.`FactTypeOperation_Status` = 2';
        } else if ($this->action == 'deleted') {
            $where = '`ftd`.`FactTypeOperation_Status` = 0';
        } else {
            $where = '`ftd`.`FactTypeOperation_Status` = 2';
        }
        return DB::select(
            "SELECT $select
            FROM `t_fact_type_operation` `ftd`
            WHERE $where",
            [ ]
        );
    }

    protected function analize($data)
    {
        return $data;
    }
}
