<?php

namespace App\Modules\FactTypeOperation\Domain;

use App\Modules\Shared\Domain\Aggregate\AggregateAttribute;
use App\Modules\Shared\Domain\Aggregate\AggregateRoot;

class FactTypeOperation extends AggregateRoot
{

    public const VALUE = 1;

    public static function defaultValue()
    {
        return self::VALUE;
    }

    /** @return AgregateAttribute[] */
    protected static function attributes(): array
    {
        return [
            new AggregateAttribute('id', IdFactTypeOperation::class, 'Id_FactTypeOperation'),
            new AggregateAttribute('name', FactTypeOperationName::class, 'FactTypeOperation_Name'),
            new AggregateAttribute('abrv', FactTypeOperationAbrv::class, 'FactTypeOperation_Abrv'),
            new AggregateAttribute('status', FactTypeOperationStatus::class, 'FactTypeOperation_Status')
        ];
    }

    public function __construct(
        private IdFactTypeOperation $id,
        private FactTypeOperationName $name,
        private FactTypeOperationAbrv $abrv,
        private FactTypeOperationStatus $status,
    ) {
    }

    public function id(): IdFactTypeOperation
    {
        return $this->id;
    }

    public function name(): FactTypeOperationName
    {
        return $this->name;
    }

    public function abrv(): FactTypeOperationAbrv
    {
        return $this->abrv;
    }

    public function status(): FactTypeOperationStatus
    {
        return $this->status;
    }
}
