<?php

namespace App\Modules\FactTypeOperation\Application\List;

use App\Modules\FactTypeOperation\Application\FactTypeOperationResponse;
use App\Modules\FactTypeOperation\Application\FactTypeOperationResponses;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;

final class FactTypeOperationListerQueryHandler implements QueryHandler
{
    public function __construct(private FactTypeOperationLister $lister)
    {
    }

    public function __invoke(FactTypeOperationListerQuery $query): FactTypeOperationResponses
    {
        return new FactTypeOperationResponses(...array_map(
            fn ($index) => new FactTypeOperationResponse(
                $index->id()->value(),
                $index->name()->value(),
                $index->abrv()->value(),
                $index->status()->value(),
            ),
            $this->lister->__invoke($query->getAction())
        ));
    }
}
