<?php

namespace App\Modules\FactTypeDocument\Infraestructure;

use App\Modules\FactTypeDocument\Domain\FactTypeDocument;
use App\Modules\FactTypeDocument\Domain\FactTypeDocumentRepository;
use App\Modules\FactTypeDocument\Domain\IdFactTypeDocument;
use App\Modules\Shared\Domain\Storage\Criteria\StorageCriteria;
use App\Modules\Shared\Infraestructure\Requester;

class MysqlFactTypeDocumentRepository implements FactTypeDocumentRepository
{

    public function find(StorageCriteria $criteria): FactTypeDocument
    {
        return FactTypeDocument::fromDTO($criteria->run());
    }

    public function search(StorageCriteria $criteria): array
    {
        return array_map(fn($btp) => FactTypeDocument::fromDTO($btp), $criteria->run());
    }

    public function insert(FactTypeDocument $value)
    {
        return Requester::requestInsert(
            'CALL sp_fact_type_document_insert(?,?,?,@sts,@cod,@msg,@id)',
            [
                $value->name()->value(),
                $value->abrv()->value(),
                $value->status()->value()
            ]
        );
    }

    public function update(FactTypeDocument $value)
    {
        return Requester::requestUpdate(
            'CALL sp_fact_type_document_update(?,?,?,?,@sts,@cod,@msg)',
            [
                $value->id()->value(),
                $value->name()->value(),
                $value->abrv()->value(),
                $value->status()->value(),
            ]
        );
    }
}
