<?php

namespace App\Modules\FactTypeDocument\Domain;

use App\Modules\Shared\Domain\Aggregate\AggregateAttribute;
use App\Modules\Shared\Domain\Aggregate\AggregateRoot;

class FactTypeDocument extends AggregateRoot
{

    /** @return AgregateAttribute[] */
    protected static function attributes(): array
    {
        return [
            new AggregateAttribute('id', IdFactTypeDocument::class, 'Id_FactTypeDocument'),
            new AggregateAttribute('name', FactTypeDocumentName::class, 'FactTypeDocument_Name'),
            new AggregateAttribute('abrv', FactTypeDocumentAbrv::class, 'FactTypeDocument_Abrv'),
            new AggregateAttribute('status', FactTypeDocumentStatus::class, 'FactTypeDocument_Status')
        ];
    }

    public function __construct(
        private IdFactTypeDocument $id,
        private FactTypeDocumentName $name,
        private FactTypeDocumentAbrv $abrv,
        private FactTypeDocumentStatus $status,
    ) {
    }

    public function id(): IdFactTypeDocument
    {
        return $this->id;
    }

    public function name(): FactTypeDocumentName
    {
        return $this->name;
    }

    public function abrv(): FactTypeDocumentAbrv
    {
        return $this->abrv;
    }

    public function status(): FactTypeDocumentStatus
    {
        return $this->status;
    }
}
