<?php

namespace App\Modules\FactTypeDocument\Application\Update;

use App\Modules\FactTypeDocument\Application\Update\FactTypeDocumentUpdaterResponse;
use App\Modules\FactTypeDocument\Domain\FactTypeDocument;
use App\Modules\FactTypeDocument\Domain\FactTypeDocumentRepository;

final class FactTypeDocumentUpdater
{
    public function __construct(private FactTypeDocumentRepository $repository)
    {
    }

    public function __invoke(FactTypeDocument $lead): FactTypeDocumentUpdaterResponse
    {
        return new FactTypeDocumentUpdaterResponse($this->repository->update($lead));
    }
}
