<?php

namespace App\Modules\FactTypeDocument\Application\Index;

use App\Modules\FactTypeDocument\Domain\IdFactTypeDocument;
use App\Modules\FactTypeDocument\Domain\FactTypeDocumentRepository;
use App\Modules\FactTypeDocument\Domain\IndexFactTypeDocument;

final class FactTypeDocumentIndexer
{
    public function __construct(private FactTypeDocumentRepository $repository)
    {
    }

    public function __invoke(IdFactTypeDocument $idFactTypeDocument)
    {
        $index = $this->repository->find(new IndexFactTypeDocument($idFactTypeDocument));
        return $index;
    }
}
