<?php

namespace App\Modules\FactReceiptDetail\Domain;

use App\Modules\FactProduct\Domain\FactProductCode;
use App\Modules\FactProduct\Domain\FactProductIdProduct;
use App\Modules\FactProduct\Domain\FactProductName;
use App\Modules\FactTypeOperation\Domain\IdFactTypeOperation;
use App\Modules\FactUnit\Domain\IdFactUnit;
use App\Modules\Shared\Domain\Aggregate\AggregateAttribute;
use App\Modules\Shared\Domain\Aggregate\AggregateRoot;

class UpdateFactReceiptDetail extends AggregateRoot
{

    /** @return AgregateAttribute[] */
    protected static function attributes(): array
    {
        return [
            new AggregateAttribute('id', IdFactReceiptDetail::class, 'Id_FactReceiptDetail'),
            new AggregateAttribute('amount', FactReceiptDetailAmount::class, 'FactReceiptDetail_Amount'),
            new AggregateAttribute('unitPrice', FactReceiptDetailUnitPrice::class, 'FactReceiptDetail_UnitPrice'),
            new AggregateAttribute('discount', FactReceiptDetailDiscount::class, 'FactReceiptDetail_Discount'),
            new AggregateAttribute('total', FactReceiptDetailTotal::class, 'FactReceiptDetail_Total'),
            new AggregateAttribute('idFactTypeOperation', IdFactTypeOperation::class, 'Id_FactTypeOperation'),
            new AggregateAttribute('idFactUnit', IdFactUnit::class, 'Id_FactUnit'),
        ];
    }

    public function __construct(
        private IdFactReceiptDetail $id,
        private FactReceiptDetailAmount $amount,
        private FactReceiptDetailUnitPrice $unitPrice,
        private FactReceiptDetailDiscount $discount,
        private FactReceiptDetailTotal $total,
        private IdFactTypeOperation $idFactTypeOperation,
        private IdFactUnit $idFactUnit,
        private FactProductCode $factProductCode,
        private FactProductName $factProductName,
        private FactProductIdProduct $factProductIdProduct,
    ) {
    }

    public function id(): IdFactReceiptDetail
    {
        return $this->id;
    }

    public function amount(): FactReceiptDetailAmount
    {
        return $this->amount;
    }

    public function unitPrice(): FactReceiptDetailUnitPrice
    {
        return $this->unitPrice;
    }

    public function discount(): FactReceiptDetailDiscount
    {
        return $this->discount;
    }

    public function total(): FactReceiptDetailTotal
    {
        return $this->total;
    }

    public function idFactTypeOperation(): IdFactTypeOperation
    {
        return $this->idFactTypeOperation;
    }

    public function idFactUnit(): IdFactUnit
    {
        return $this->idFactUnit;
    }

    public function factProductCode(): FactProductCode
    {
        return $this->factProductCode;
    }

    public function factProductName(): FactProductName
    {
        return $this->factProductName;
    }

    public function factProductIdProduct(): FactProductIdProduct
    {
        return $this->factProductIdProduct;
    }
}
