<?php

namespace App\Modules\FactReceiptDetail\Domain;

use App\Modules\FactProduct\Domain\FactProduct;
use App\Modules\FactReceipt\Domain\IdFactReceipt;
use App\Modules\FactUnit\Domain\FactUnit;
use App\Modules\Shared\Domain\Storage\Criteria\StorageCriteria;
use Illuminate\Support\Facades\DB;

class ListFactReceiptDetail implements StorageCriteria
{

    public function __construct(
        private IdFactReceipt $idFactReceipt,
        private string $action
    ) {
    }

    public function run()
    {
        return $this->analize($this->query());
    }

    protected function query()
    {
        $select = FactReceiptDetail::select('`ftd`');
        $selectProduct = FactProduct::select('`fp`');
        $selectUnit = FactUnit::select('`fu`');
        if ($this->action == 'all') {
            $where = '`ftd`.`FactReceiptDetail_Status` IN (1, 2)';
        } else if ($this->action == 'active') {
            $where = '`ftd`.`FactReceiptDetail_Status` = 2';
        } else if ($this->action == 'deleted') {
            $where = '`ftd`.`FactReceiptDetail_Status` = 0';
        } else {
            $where = '`ftd`.`FactReceiptDetail_Status` = 2';
        }
        return DB::select(
            "SELECT $select, $selectProduct, $selectUnit
            FROM `t_fact_receipt_detail` `ftd`
            INNER JOIN `t_fact_product` `fp` ON `ftd`.`Id_FactProduct` = `fp`.`Id_FactProduct`
            INNER JOIN `t_fact_unit` `fu` ON `ftd`.`Id_FactUnit` = `fu`.`Id_FactUnit`
            WHERE $where
            AND `ftd`.`Id_FactReceipt` = ?",
            [$this->idFactReceipt->value()]
        );
    }

    protected function analize($data)
    {
        return $data;
    }
}
