<?php

namespace App\Modules\FactReceiptDetail\Application\Update;

use App\Modules\Shared\Domain\Bus\Query\Query;

final class FactReceiptDetailUpdaterQuery implements Query
{
    public function __construct(
        private int $id,
        private float $amount,
        private float $unitPrice,
        private float $discount,
        private float $total,
        private int $idFactTypeOperation,
        private int $idFactUnit,
        private string $factProductCode,
        private string $factProductName,
        private string $factProductIdProduct,
    ) {
    }

    public function id(): int
    {
        return $this->id;
    }

    public function amount(): string
    {
        return $this->amount;
    }

    public function unitPrice(): string
    {
        return $this->unitPrice;
    }

    public function discount(): string
    {
        return $this->discount;
    }

    public function total(): string
    {
        return $this->total;
    }

    public function idFactTypeOperation(): int
    {
        return $this->idFactTypeOperation;
    }

    public function idFactUnit(): int
    {
        return $this->idFactUnit;
    }

    public function factProductCode(): string
    {
        return $this->factProductCode;
    }

    public function factProductName(): string
    {
        return $this->factProductName;
    }

    public function factProductIdProduct(): string
    {
        return $this->factProductIdProduct;
    }
}
