<?php

namespace App\Modules\FactReceiptDetail\Application\Create;

use App\Modules\Shared\Domain\Bus\Query\Query;

final class CreateFactReceiptDetailQuery implements Query
{
    public function __construct(
        private float $amount,
        private float $unitPrice,
        private float $discount,
        private float $total,
        private int $status,
        private int $idFactProduct,
        private int $idFactTypeOperation,
        private int $idFactUnit,
        private int $idFactReceipt,
    ) {
    }

    public function amount(): float
    {
        return $this->amount;
    }

    public function unitPrice(): float
    {
        return $this->unitPrice;
    }

    public function discount(): float
    {
        return $this->discount;
    }

    public function total(): float
    {
        return $this->total;
    }

    public function status(): int
    {
        return $this->status;
    }

    public function idFactProduct(): int
    {
        return $this->idFactProduct;
    }

    public function idFactTypeOperation(): int
    {
        return $this->idFactTypeOperation;
    }

    public function idFactUnit(): int
    {
        return $this->idFactUnit;
    }

    public function idFactReceipt(): int
    {
        return $this->idFactReceipt;
    }
}
