<?php

namespace App\Modules\FactReceipt\Domain;

use App\Modules\FactProduct\Domain\FactProduct;
use App\Modules\FactReceiptDetail\Domain\FactReceiptDetail;
use App\Modules\FactTypeOperation\Domain\FactTypeOperation;
use App\Modules\FactUnit\Domain\FactUnit;

class DTOSyncItemFacBo
{
    public function __construct(
        public string $CodigoProducto,
        public string $DescripcionProducto,
        public float $Cantidad,
        public float $PrecioUnitario,
        public float $Descuento,
        public string $TipoOperacion,
        public string $UnidadMedidaSunat,
    ) {
    }

    public static function fromFactReceiptDetail(FactReceiptDetail $factReceiptDetail, FactProduct $product, FactTypeOperation $typeOperation, FactUnit $unit)
    {
        return new DTOSyncItemFacBo(
            CodigoProducto: $product->code()->value(),
            DescripcionProducto: $product->name()->value(),
            Cantidad: $factReceiptDetail->amount()->value(),
            PrecioUnitario: $factReceiptDetail->unitPrice()->value(),
            Descuento: $factReceiptDetail->discount()->value(),
            TipoOperacion: $typeOperation->abrv()->value(),
            UnidadMedidaSunat: $unit->abrv()->value(),
        );
    }
}
