<?php

namespace App\Modules\FactReceipt\Domain;

use DateTime;

class DTODatosComprobante
{
    /**
     * @param array<DTOItemVentaMovil> $ListaItemsPedidoMovil
     */
    public function __construct(
        public ?string $IdComprobante,
        public string $TipoComprobante,
        public ?string $SerieNumero,
        public string $TipoDocumento,
        public string $NroDocumento,
        public string $NombreRazonSocial,
        public string $Direccion,
        public string $ModalidadPago,
        public float $MontoTotal,
        public string $Moneda,
        public string $EmailAdquiriente,
        public int $Estado,
        public DateTime $FechaEmision,
        public DateTime $FechaVencimiento,
        public float $PagoInicial,
        public int $SolicitarComprobante,
        public float $Pagado,
        public float $PorPagar,
        public ?DTOEtiquetasRI $EtiquetasRI,
        public array $ListaItemsPedidoMovil
    ) {
    }

    public function toJSON()
    {
        return [
            'IdComprobante' => $this->IdComprobante,
            'TipoComprobante' => $this->TipoComprobante,
            'SerieNumero' => $this->SerieNumero,
            'TipoDocumento' => $this->TipoDocumento,
            'NroDocumento' => $this->NroDocumento,
            'NombreRazonSocial' => $this->NombreRazonSocial,
            'Direccion' => $this->Direccion,
            'ModalidadPago' => $this->ModalidadPago,
            'MontoTotal' => $this->MontoTotal,
            'Moneda' => $this->Moneda,
            'EmailAdquiriente' => $this->EmailAdquiriente,
            // 'EmailAdquiriente' => null,
            'Estado' => $this->Estado,
            'FechaEmision' => $this->FechaEmision->format(DATE_ATOM),
            'FechaVencimiento' => $this->FechaVencimiento->format(DATE_ATOM),
            'PagoInicial' => $this->PagoInicial,
            'Pagado' => $this->Pagado,
            'PorPagar' => $this->PorPagar,
            'ListaItemsPedidoMovil' => array_map(fn ($i) => $i->toObject(), $this->ListaItemsPedidoMovil),
            'ListPagosMultiples' => null,
            'EtiquetasRI' => $this->EtiquetasRI ? $this->EtiquetasRI->toObject() : null,
            'SolicitarComprobante' => $this->SolicitarComprobante,
        ];
    }
}
