<?php

namespace App\Modules\FactReceipt\Application\Index;

use App\Modules\FactReceipt\Application\Index\FactReceiptIndexerResponse;
use App\Modules\FactReceipt\Domain\IdFactReceipt;
use App\Modules\FactReceipt\Domain\FactReceiptRepository;
use App\Modules\FactReceipt\Domain\IndexFactReceipt;

final class FactReceiptIndexer
{
    public function __construct(private FactReceiptRepository $repository)
    {
    }

    public function __invoke(IdFactReceipt $idFactReceipt)
    {
        $index = $this->repository->find(new IndexFactReceipt($idFactReceipt));
        return $index;
    }
}
