<?php

namespace App\Modules\FactPaymentMethod\Application\Update;

use App\Modules\FactPaymentMethod\Application\Index\FactPaymentMethodIndexer;
use App\Modules\FactPaymentMethod\Domain\IdFactPaymentMethod;
use App\Modules\FactPaymentMethod\Domain\FactPaymentMethodAbrv;
use App\Modules\FactPaymentMethod\Domain\FactPaymentMethodName;
use App\Modules\FactPaymentMethod\Domain\FactPaymentMethodStatus;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;

final class UpdateFactPaymentMethodQueryHandler implements QueryHandler
{
    public function __construct(
        private FactPaymentMethodUpdater $updater,
        private FactPaymentMethodIndexer $indexer
    ) {
    }

    public function __invoke(UpdateFactPaymentMethodQuery $query): UpdateFactPaymentMethodResponse
    {
        $index = $this->indexer->__invoke(new IdFactPaymentMethod($query->id()), true);
        $index->setName(new FactPaymentMethodName($query->name()));
        $index->setAbrv(new FactPaymentMethodAbrv($query->abrv()));
        $index->setStatus(new FactPaymentMethodStatus($query->status()));
        $this->updater->__invoke($index);
        return new UpdateFactPaymentMethodResponse();
    }
}
