<?php

namespace App\Modules\FactPaymentMethod\Application\Create;

use App\Modules\FactPaymentMethod\Domain\IdFactPaymentMethod;
use App\Modules\FactPaymentMethod\Domain\FactPaymentMethod;
use App\Modules\FactPaymentMethod\Domain\FactPaymentMethodAbrv;
use App\Modules\FactPaymentMethod\Domain\FactPaymentMethodName;
use App\Modules\FactPaymentMethod\Domain\FactPaymentMethodStatus;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;

final class CreateFactPaymentMethodQueryHandler implements QueryHandler
{
    public function __construct(private FactPaymentMethodCreator $creator)
    {
    }

    public function __invoke(CreateFactPaymentMethodQuery $query): CreateFactPaymentMethodResponse
    {
        $model = new FactPaymentMethod(
            new IdFactPaymentMethod(0),
            new FactPaymentMethodName($query->name()),
            new FactPaymentMethodAbrv($query->abrv()),
            new FactPaymentMethodStatus($query->status()),
        );
        return new CreateFactPaymentMethodResponse($this->creator->__invoke($model));
    }
}
