<?php

namespace App\Modules\FactCurrency\Application\List;

use App\Modules\FactCurrency\Application\FactCurrencyResponse;
use App\Modules\FactCurrency\Application\FactCurrencyResponses;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;

final class ListFactCurrencyQueryHandler implements QueryHandler
{
    public function __construct(private FactCurrencyLister $lister)
    {
    }

    public function __invoke(ListFactCurrencyQuery $query): FactCurrencyResponses
    {
        return new FactCurrencyResponses(...array_map(
            fn ($index) => new FactCurrencyResponse(
                $index->id()->value(),
                $index->name()->value(),
                $index->abrv()->value(),
                $index->status()->value(),
            ),
            $this->lister->__invoke($query->getAction())
        ));
    }
}
