<?php

namespace App\Modules\ExternalUser\Infraestructure;

use App\Modules\ExternalUser\Domain\HCHtlUsageDateUsage;
use App\Modules\ExternalUser\Domain\ExternalUser;
use App\Modules\ExternalUser\Domain\ExternalUserRepository;
use App\Modules\ExternalUser\Domain\IdExternalUser;
use App\Modules\Shared\Infraestructure\Requester;

class MysqlExternalUserRepository implements ExternalUserRepository
{

    public function find(string $query, string $action)
    {
        return Requester::requestSelect(
            'CALL sp_external_user_list(?,?,@sts,@cod,@msg)',
            [
                $query,
                $action
            ]
        );
    }

    public function index(IdExternalUser $id)
    {
        return Requester::requestSelect(
            'CALL sp_external_user_index(?,@sts,@cod,@msg)',
            [
                $id->value(),
            ]
        );
    }

    public function insert(ExternalUser $value)
    {
        return Requester::requestInsert(
            'CALL sp_external_user_insert(?,?,?,?,?,?,@sts,@cod,@msg,@id)',
            [
                $value->getName()->value(),
                $value->getLastName()->value(),
                $value->getNickName()->value(),
                $value->getGender()->value(),
                $value->getStatus()->value(),
                $value->getIdExternal()->value(),
            ]
        );
    }

    public function update(ExternalUser $value)
    {
        return Requester::requestUpdate(
            'CALL sp_external_user_update(?,?,?,?,?,?,?,@sts,@cod,@msg)',
            [
                $value->getId()->value(),
                $value->getName()->value(),
                $value->getLastName()->value(),
                $value->getNickName()->value(),
                $value->getGender()->value(),
                $value->getStatus()->value(),
                $value->getIdExternal()->value(),
            ]
        );
    }

    public function delete(IdExternalUser $id)
    {
        return Requester::requestUpdate(
            'CALL sp_external_user_delete(?,@sts,@cod,@msg)',
            [
                $id->value(),
            ]
        );
    }
}
