<?php

namespace App\Modules\ExternalReview\Infraestructure;

use App\Modules\ExternalReview\Domain\ExternalReview;
use App\Modules\ExternalReview\Domain\ExternalReviewRepository;
use App\Modules\ExternalReview\Domain\IdExternalReview;
use App\Modules\ExternalReview\Domain\InsertExternalReview;
use App\Modules\ExternalReview\Domain\UpdateExternalReview;
use App\Modules\GroupPassenger\Domain\IdGroupPassenger;
use App\Modules\Shared\Domain\DateEnd;
use App\Modules\Shared\Domain\DateStart;
use App\Modules\Shared\Infraestructure\Requester;

class MysqlExternalReviewRepository implements ExternalReviewRepository
{

    public function groupFind(IdGroupPassenger $idGroupPassenger, string $action)
    {
        return Requester::requestSelect(
            'CALL sp_external_review_group_list(?,?,?,@sts,@cod,@msg)',
            [
                $idGroupPassenger->value(),
                $action,
                config('var.PATH_PUBLIC')
            ]
        );
    }

    public function find(string $action, DateStart $dateStart, DateEnd $dateEnd)
    {
        return Requester::requestSelect(
            'CALL sp_external_review_list(?,?,?,?,@sts,@cod,@msg)',
            [
                $action,
                $dateStart->value(),
                $dateEnd->value(),
                config('var.PATH_PUBLIC')
            ]
        );
    }

    public function index(IdExternalReview $id)
    {
        return Requester::requestSelect(
            'CALL sp_external_review_index(?,@sts,@cod,@msg)',
            [
                $id->value(),
            ]
        );
    }

    public function insert(InsertExternalReview $value)
    {
        return Requester::requestInsert(
            'CALL sp_external_review_insert(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,@sts,@cod,@msg,@id)',
            [
                $value->getExternalReviewDateReview()->value(),
                $value->getExternalReviewRoute()->value(),
                $value->getExternalReviewTitle()->value(),
                $value->getExternalReviewValue()->value(),
                $value->getExternalReviewScore()->value(),
                $value->getExternalReviewType()->value(),
                $value->getExternalReviewStatus()->value(),
                $value->getIdExternalUser()->value(),
                $value->getIdExternalUserPassenger()->value(),
                $value->getIdGroupPassenger()->value(),
                $value->getIdBookingRelationship()->getValue(),
                $value->getIdLanguage()->value(),
                $value->getIdExternal()->value(),
                $value->getIdAdmin()->value(),
                $value->getIdExternalReview()->value(),
            ]
        );
    }

    public function update(UpdateExternalReview $value)
    {
        return Requester::requestUpdate(
            'CALL sp_external_review_update(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,@sts,@cod,@msg)',
            [
                $value->getId()->value(),
                $value->getExternalReviewDateReview()->value(),
                $value->getExternalReviewRoute()->value(),
                $value->getExternalReviewTitle()->value(),
                $value->getExternalReviewValue()->value(),
                $value->getExternalReviewScore()->value(),
                $value->getExternalReviewType()->value(),
                $value->getExternalReviewStatus()->value(),
                $value->getIdExternalUser()->value(),
                $value->getIdExternalUserPassenger()->value(),
                $value->getIdGroupPassenger()->value(),
                $value->getIdBookingRelationship()->getValue(),
                $value->getIdLanguage()->value(),
                $value->getIdExternal()->value(),
                $value->getIdExternalReview()->value(),
            ]
        );
    }

    public function delete(IdExternalReview $id)
    {
        return Requester::requestUpdate(
            'CALL sp_external_review_delete(?,@sts,@cod,@msg)',
            [
                $id->value(),
            ]
        );
    }
}
