<?php

namespace App\Modules\ExternalApiRequest\Application\Index;

use App\Modules\ExternalApiRequest\Domain\IdExternalApiRequest;
use App\Modules\ExternalApiRequest\Domain\ExternalApiRequestRepository;
use App\Modules\ExternalApiRequest\Domain\IndexExternalApiRequest;

final class ExternalApiRequestIndexer
{
    public function __construct(private ExternalApiRequestRepository $repository)
    {
    }

    public function __invoke(IdExternalApiRequest $idExternalApiRequest, bool $lockInShare = false)
    {
        return $this->repository->find(new IndexExternalApiRequest($idExternalApiRequest, $lockInShare));
    }
}
