<?php

namespace App\Modules\CashMovementFactReceipt\Infraestructure;

class CashMovementFactReceiptValidators
{
    public const INSERT = [
        'FactReceipt_DateEmission'                          => 'required|string|string',
        'FactReceipt_NoDocument'                            => 'required|string|max:250',
        'FactReceipt_BusinessName'                          => 'required|string|max:250',
        'FactReceipt_Email'                                 => 'required|string|max:250',
        'FactReceipt_Address'                               => 'required|string|max:500',
        'FactReceipt_LicensePlate'                          => 'string|max:250',
        'FactReceipt_Currency'                              => 'required|string|max:10',
        'Id_FactTypeReceipt'                                => 'required|int',
        'Id_FactTypeDocument'                               => 'required|int',
        'Id_FactPaymentMethod'                              => 'required|int',
        'Id_FactCurrency'                                   => 'required|int',

        'FactReceiptDetail'                                 => 'required|array',
        'FactReceiptDetail.*.FactReceiptDetail_Amount'      => 'required|numeric',
        'FactReceiptDetail.*.FactReceiptDetail_UnitPrice'   => 'required|numeric',
        'FactReceiptDetail.*.FactReceiptDetail_Discount'    => 'required|numeric',
        'FactReceiptDetail.*.FactReceiptDetail_Total'       => 'required|numeric',
        'FactReceiptDetail.*.FactReceiptDetail_Status'      => 'required|int',
        'FactReceiptDetail.*.Id_FactTypeOperation'          => 'required|int',
        'FactReceiptDetail.*.Id_FactUnit'                   => 'required|int',

        'FactReceiptDetail.*.FactProduct_Code'              => 'string|max:10',
        'FactReceiptDetail.*.FactProduct_Name'              => 'required|string|max:1500',
    ];

    public const UPDATE = [
        'Id_CashMovementFactReceipt'        => 'required|int',
        'CashMovementFactReceipt_Status'    => 'required|int',
        'Id_CashMovement'                   => 'required|int',
        'Id_FactReceipt'                    => 'required|int',
    ];
}
