<?php

namespace App\Modules\CashMovementFactReceipt\Application\Index;

use App\Modules\CashMovementFactReceipt\Domain\IdCashMovementFactReceipt;
use App\Modules\CashMovementFactReceipt\Domain\CashMovementFactReceiptRepository;
use App\Modules\CashMovementFactReceipt\Domain\IndexCashMovementFactReceipt;

final class CashMovementFactReceiptIndexer
{
    public function __construct(private CashMovementFactReceiptRepository $repository)
    {
    }

    public function __invoke(IdCashMovementFactReceipt $idCashMovementFactReceipt)
    {
        $index = $this->repository->find(new IndexCashMovementFactReceipt($idCashMovementFactReceipt));
        return $index;
    }
}
