<?php

namespace App\Modules\CashMovementDetail\Application\List;

use App\Modules\CashMovement\Domain\IdCashMovement;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;

final class ListCashMovementDetailQueryHandler implements QueryHandler
{
    public function __construct(private CashMovementDetailLister $lister)
    {
    }

    public function __invoke(ListCashMovementDetailQuery $query): ListCashMovementDetailResponse
    {
        return $this->lister->__invoke(new IdCashMovement($query->id()), $query->action());
    }
}
