<?php

namespace App\Modules\CashMovement\Application\UpdateCycleType;

use App\Modules\CashMovement\Domain\CashMovementCycleType;
use App\Modules\CashMovement\Domain\IdCashMovement;
use App\Modules\CashMovement\Domain\CashMovementRepository;

final class CashMovementCycleTypeUpdater
{
    public function __construct(private CashMovementRepository $repository)
    {
    }

    public function __invoke(IdCashMovement $idCashMovement, CashMovementCycleType $cycleType): UpdateCycleTypeCashMovementResponse
    {
        return new UpdateCycleTypeCashMovementResponse(
            $this->repository->updateCycleType($idCashMovement, $cycleType)
        );
    }
}
