<?php

namespace App\Modules\Briefing\Application\ListBookingTourPassenger;

use App\Modules\BookingTour\Domain\IdBookingTour;
use App\Modules\Briefing\Domain\BriefingOrderBy;
use App\Modules\Briefing\Domain\BriefingType;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;
use App\Modules\Shared\Domain\DateTimeEnd;
use App\Modules\Shared\Domain\DateTimeStart;

final class ListBookingTourPassengerBriefingQueryHandler implements QueryHandler
{
    public function __construct(private BriefingBookingTourPassengerLister $lister)
    {
    }

    public function __invoke(ListBookingTourPassengerBriefingQuery $query): ListBookingTourPassengerBriefingResponses
    {
        return new ListBookingTourPassengerBriefingResponses(...array_map(
            fn ($index) => new ListBookingTourPassengerBriefingResponse(
                $index->Id_Passenger,
                $index->Passenger_Name,
                $index->Passenger_LastName,
                $index->Passenger_Email,
                $index->Passenger_Phone,
                $index->Passenger_PhoneCode,
                $index->Passenger_Gender,
                $index->Passenger_DOB,
                $index->Passenger_NoDocument,
                $index->Id_UserCountry,
                $index->UserCountry_Name,
                $index->UserCountry_Img,
                $index->UserCountry_Path,
                $index->Id_BookingTourPassenger,
                $index->BookingTourPassenger_Status,
                $index->BookingTourPassenger_PaymentStatus,
                $index->Id_BookingTour,
                $index->BookingTour_DateStart,
                $index->BookingTour_PickUp,
                $index->BookingTour_Type,
                $index->BookingTour_NoPax,
                $index->BookingTour_Name,
                $index->BookingTour_TourName,
                $index->BookingTour_FeeType,
                $index->BookingTour_Full,
                $index->BookingTour_MinimumFull,
                $index->BookingTour_Group,
                $index->BookingTour_TourDuration,
                $index->BookingTour_DateBriefing,
                $index->BookingTour_PlaceBriefing,
                $index->BookingTour_UseBookingPlaceBriefing,
                $index->BookingTour_Status,
                $index->Id_Booking,
                $index->Booking_Code,
                $index->Id_Package,
                $index->Id_Tour,
                $index->Id_Group
            ),
            $this->lister->__invoke(
                new DateTimeStart($query->dateTimeStart()),
                new DateTimeEnd($query->dateTimeEnd()),
                new BriefingType($query->type()),
                new BriefingOrderBy($query->orderBy()),
                new IdBookingTour($query->idBookingTour())
            )
        ));
    }
}
