<?php

namespace App\Modules\BookingUpgradePassenger\Domain;

use App\Modules\Admin\Domain\IdAdmin;
use App\Modules\Booking\Domain\BookingCode;
use App\Modules\Booking\Domain\BookingInternalRemark;
use App\Modules\Booking\Domain\BookingObservation;
use App\Modules\Booking\Domain\IdBooking;
use App\Modules\BookingUpgrade\Domain\IdBookingUpgrade;
use App\Modules\BookingTour\Domain\BookingTourDateStart;
use App\Modules\BookingTour\Domain\BookingTourTourDuration;
use App\Modules\BookingTour\Domain\BookingTourTourName;
use App\Modules\BookingTour\Domain\IdBookingTour;
use App\Modules\BookingTourPassenger\Domain\IdBookingTourPassenger;
use App\Modules\Passenger\Domain\IdPassenger;
use App\Modules\Passenger\Domain\PassengerGender;
use App\Modules\Passenger\Domain\PassengerLastName;
use App\Modules\Passenger\Domain\PassengerName;
use App\Modules\Provider\Domain\IdProvider;
use App\Modules\Shared\Domain\Aggregate\AggregateAttribute;
use App\Modules\Shared\Domain\Aggregate\AggregateRoot;
use App\Modules\UserCountry\Domain\IdUserCountry;
use App\Modules\UserCountry\Domain\UserCountryImg;
use App\Modules\UserCountry\Domain\UserCountryName;

class ListBookingUpgradePassenger extends AggregateRoot
{

    /** @return AgregateAttribute[] */
    protected static function attributes(): array
    {
        return [
            new AggregateAttribute('id', IdBookingUpgradePassenger::class, 'Id_BookingUpgradePassenger'),
            new AggregateAttribute('is23MigrationValue', BookingUpgradePassengerIs23MigrationValue::class, 'BookingUpgradePassenger_Is23MigrationValue'),
            new AggregateAttribute('date', BookingUpgradePassengerDate::class, 'BookingUpgradePassenger_Date'),
            new AggregateAttribute('dateOnlyReturn', BookingUpgradePassengerOnlyReturn::class, 'BookingUpgradePassenger_OnlyReturn'),
            new AggregateAttribute('dateEntry', BookingUpgradePassengerDateEntry::class, 'BookingUpgradePassenger_DateEntry'),
            new AggregateAttribute('dateReturn', BookingUpgradePassengerDateReturn::class, 'BookingUpgradePassenger_Datereturn'),
            new AggregateAttribute('datePurchase', BookingUpgradePassengerDatePurchase::class, 'BookingUpgradePassenger_DatePurchase'),
            new AggregateAttribute('carrier', BookingUpgradePassengerCarrier::class, 'BookingUpgradePassenger_Carrier'),
            new AggregateAttribute('code', BookingUpgradePassengerCode::class, 'BookingUpgradePassenger_Code'),
            new AggregateAttribute('amount', BookingUpgradePassengerAmount::class, 'BookingUpgradePassenger_Amount'),

            new AggregateAttribute('roundCarrier', BookingUpgradePassengerRoundCarrier::class, 'BookingUpgradePassenger_RoundCarrier'),
            new AggregateAttribute('roundCode', BookingUpgradePassengerRoundCode::class, 'BookingUpgradePassenger_RoundCode'),
            new AggregateAttribute('roundAmount', BookingUpgradePassengerRoundAmount::class, 'BookingUpgradePassenger_RoundAmount'),

            new AggregateAttribute('remark', BookingUpgradePassengerRemark::class, 'BookingUpgradePassenger_Remark'),
            new AggregateAttribute('mask', BookingUpgradePassengerMask::class, 'BookingUpgradePassenger_Mask'),
            new AggregateAttribute('status', BookingUpgradePassengerStatus::class, 'BookingUpgradePassenger_Status'),
            new AggregateAttribute('idProvider', IdProvider::class, 'Id_Provider'),
            new AggregateAttribute('idProviderReturn', IdProvider::class, 'Id_Provider_Return'),
            new AggregateAttribute('idAdmin', IdAdmin::class, 'Id_Admin'),
            new AggregateAttribute('idBookingUpgrade', IdBookingUpgrade::class, 'Id_BookingUpgrade'),
            new AggregateAttribute('idBookingTourPassenger', IdBookingTourPassenger::class, 'Id_BookingTourPassenger'),

            new AggregateAttribute('idPassenger', IdPassenger::class, 'Id_Passenger'),
            new AggregateAttribute('passengerGender', PassengerGender::class, 'Passenger_Gender'),
            new AggregateAttribute('passengerName', PassengerName::class, 'Passenger_Name'),
            new AggregateAttribute('passengerLastName', PassengerLastName::class, 'Passenger_LastName'),
            new AggregateAttribute('idBookingTour', IdBookingTour::class, 'Id_BookingTour'),
            new AggregateAttribute('bookingTourTourName', BookingTourTourName::class, 'BookingTour_TourName'),
            new AggregateAttribute('bookingTourDateStart', BookingTourDateStart::class, 'BookingTour_DateStart'),
            new AggregateAttribute('bookingTourTourDuration', BookingTourTourDuration::class, 'BookingTour_TourDuration'),
            new AggregateAttribute('idBooking', IdBooking::class, 'Id_Booking'),
            new AggregateAttribute('bookingCode', BookingCode::class, 'Booking_Code'),
            new AggregateAttribute('bookingInternalRemark', BookingInternalRemark::class, 'Booking_InternalRemark'),
            new AggregateAttribute('bookingObservation', BookingObservation::class, 'Booking_Observation'),
            new AggregateAttribute('idUserCountry', IdUserCountry::class, 'Id_UserCountry'),
            new AggregateAttribute('userCountryName', UserCountryName::class, 'UserCountry_Name'),
            new AggregateAttribute('userCountryImg', UserCountryImg::class, 'UserCountry_Img'),
        ];
    }

    public function __construct(
        private IdBookingUpgradePassenger $id,
        private BookingUpgradePassengerIs23MigrationValue $is23MigrationValue,
        private BookingUpgradePassengerDate $date,
        private BookingUpgradePassengerOnlyReturn $dateOnlyReturn,
        private BookingUpgradePassengerDateEntry $dateEntry,
        private BookingUpgradePassengerDateReturn $dateReturn,
        private BookingUpgradePassengerDatePurchase $datePurchase,
        private BookingUpgradePassengerCarrier $carrier,
        private BookingUpgradePassengerCode $code,
        private BookingUpgradePassengerAmount $amount,

        private BookingUpgradePassengerRoundCarrier $roundCarrier,
        private BookingUpgradePassengerRoundCode $roundCode,
        private BookingUpgradePassengerRoundAmount $roundAmount,

        private BookingUpgradePassengerRemark $remark,
        private BookingUpgradePassengerMask $mask,
        private BookingUpgradePassengerStatus $status,
        private IdProvider $idProvider,
        private IdProvider $idProviderReturn,
        private IdAdmin $idAdmin,
        private IdBookingUpgrade $idBookingUpgrade,
        private IdBookingTourPassenger $idBookingTourPassenger,

        private IdPassenger $idPassenger,
        private PassengerGender $passengerGender,
        private PassengerName $passengerName,
        private PassengerLastName $passengerLastName,
        private IdBookingTour $idBookingTour,
        private BookingTourTourName $bookingTourTourName,
        private BookingTourDateStart $bookingTourDateStart,
        private BookingTourTourDuration $bookingTourTourDuration,
        private IdBooking $idBooking,
        private BookingCode $bookingCode,
        private BookingInternalRemark $bookingInternalRemark,
        private BookingObservation $bookingObservation,
        private IdUserCountry $idUserCountry,
        private UserCountryName $userCountryName,
        private UserCountryImg $userCountryImg,
    ) {
    }

    public function id(): IdBookingUpgradePassenger
    {
        return $this->id;
    }

    public function is23MigrationValue(): BookingUpgradePassengerIs23MigrationValue
    {
        return $this->is23MigrationValue;
    }

    public function date(): BookingUpgradePassengerDate
    {
        return $this->date;
    }

    public function dateOnlyReturn(): BookingUpgradePassengerOnlyReturn
    {
        return $this->dateOnlyReturn;
    }

    public function dateEntry(): BookingUpgradePassengerDateEntry
    {
        return $this->dateEntry;
    }

    public function dateReturn(): BookingUpgradePassengerDateReturn
    {
        return $this->dateReturn;
    }

    public function datePurchase(): BookingUpgradePassengerDatePurchase
    {
        return $this->datePurchase;
    }

    public function carrier(): BookingUpgradePassengerCarrier
    {
        return $this->carrier;
    }

    public function code(): BookingUpgradePassengerCode
    {
        return $this->code;
    }

    public function amount(): BookingUpgradePassengerAmount
    {
        return $this->amount;
    }

    public function roundCarrier(): BookingUpgradePassengerRoundCarrier
    {
        return $this->roundCarrier;
    }

    public function roundCode(): BookingUpgradePassengerRoundCode
    {
        return $this->roundCode;
    }

    public function roundAmount(): BookingUpgradePassengerRoundAmount
    {
        return $this->roundAmount;
    }

    public function remark(): BookingUpgradePassengerRemark
    {
        return $this->remark;
    }

    public function mask(): BookingUpgradePassengerMask
    {
        return $this->mask;
    }

    public function status(): BookingUpgradePassengerStatus
    {
        return $this->status;
    }

    public function idProvider(): IdProvider
    {
        return $this->idProvider;
    }

    public function idProviderReturn(): IdProvider
    {
        return $this->idProviderReturn;
    }

    public function idAdmin(): IdAdmin
    {
        return $this->idAdmin;
    }

    public function idBookingUpgrade(): IdBookingUpgrade
    {
        return $this->idBookingUpgrade;
    }

    public function idBookingTourPassenger(): IdBookingTourPassenger
    {
        return $this->idBookingTourPassenger;
    }

    public function idPassenger(): IdPassenger
    {
        return $this->idPassenger;
    }

    public function passengerGender(): PassengerGender
    {
        return $this->passengerGender;
    }

    public function passengerName(): PassengerName
    {
        return $this->passengerName;
    }

    public function passengerLastName(): PassengerLastName
    {
        return $this->passengerLastName;
    }

    public function idBookingTour(): IdBookingTour
    {
        return $this->idBookingTour;
    }
    public function bookingTourTourName(): BookingTourTourName
    {
        return $this->bookingTourTourName;
    }
    public function bookingTourDateStart(): BookingTourDateStart
    {
        return $this->bookingTourDateStart;
    }
    public function bookingTourTourDuration(): BookingTourTourDuration
    {
        return $this->bookingTourTourDuration;
    }
    public function idBooking(): IdBooking
    {
        return $this->idBooking;
    }
    public function bookingCode(): BookingCode
    {
        return $this->bookingCode;
    }
    public function bookingInternalRemark(): BookingInternalRemark
    {
        return $this->bookingInternalRemark;
    }
    public function bookingObservation(): BookingObservation
    {
        return $this->bookingObservation;
    }
    public function idUserCountry(): IdUserCountry
    {
        return $this->idUserCountry;
    }
    public function userCountryName(): UserCountryName
    {
        return $this->userCountryName;
    }
    public function userCountryImg(): UserCountryImg
    {
        return $this->userCountryImg;
    }
}
