<?php

namespace App\Modules\BookingUpgradePassenger\Domain;

use App\Modules\Admin\Domain\IdAdmin;
use App\Modules\BookingTourPassenger\Domain\IdBookingTourPassenger;
use App\Modules\BookingUpgrade\Domain\IdBookingUpgrade;
use App\Modules\Provider\Domain\IdProvider;
use App\Modules\Shared\Domain\Aggregate\AggregateAttribute;
use App\Modules\Shared\Domain\Aggregate\AggregateRoot;

class BookingUpgradePassenger extends AggregateRoot
{

    /** @return AgregateAttribute[] */
    protected static function attributes(): array
    {
        return [
            new AggregateAttribute('is23MigrationValue', BookingUpgradePassengerIs23MigrationValue::class, 'BookingUpgradePassenger_Is23MigrationValue'),
            new AggregateAttribute('date', BookingUpgradePassengerDate::class, 'BookingUpgradePassenger_Date'),
            new AggregateAttribute('dateOnlyReturn', BookingUpgradePassengerOnlyReturn::class, 'BookingUpgradePassenger_OnlyReturn'),
            new AggregateAttribute('dateEntry', BookingUpgradePassengerDateEntry::class, 'BookingUpgradePassenger_DateEntry'),
            new AggregateAttribute('dateReturn', BookingUpgradePassengerDateReturn::class, 'BookingUpgradePassenger_Datereturn'),
            new AggregateAttribute('datePurchase', BookingUpgradePassengerDatePurchase::class, 'BookingUpgradePassenger_DatePurchase'),
            new AggregateAttribute('carrier', BookingUpgradePassengerCarrier::class, 'BookingUpgradePassenger_Carrier'),
            new AggregateAttribute('code', BookingUpgradePassengerCode::class, 'BookingUpgradePassenger_Code'),
            new AggregateAttribute('amount', BookingUpgradePassengerAmount::class, 'BookingUpgradePassenger_Amount'),

            new AggregateAttribute('roundCarrier', BookingUpgradePassengerRoundCarrier::class, 'BookingUpgradePassenger_RoundCarrier'),
            new AggregateAttribute('roundCode', BookingUpgradePassengerRoundCode::class, 'BookingUpgradePassenger_RoundCode'),
            new AggregateAttribute('roundAmount', BookingUpgradePassengerRoundAmount::class, 'BookingUpgradePassenger_RoundAmount'),

            new AggregateAttribute('remark', BookingUpgradePassengerRemark::class, 'BookingUpgradePassenger_Remark'),
            new AggregateAttribute('mask', BookingUpgradePassengerMask::class, 'BookingUpgradePassenger_Mask'),
            new AggregateAttribute('status', BookingUpgradePassengerStatus::class, 'BookingUpgradePassenger_Status'),
            new AggregateAttribute('idProvider', IdProvider::class, 'Id_Provider'),
            new AggregateAttribute('idProviderReturn', IdProvider::class, 'Id_Provider_Return'),
            new AggregateAttribute('idAdmin', IdAdmin::class, 'Id_Admin'),
            new AggregateAttribute('idBookingUpgrade', IdBookingUpgrade::class, 'Id_BookingUpgrade'),
            new AggregateAttribute('idBookingTourPassenger', IdBookingTourPassenger::class, 'Id_BookingTourPassenger'),
            new AggregateAttribute('id', IdBookingUpgradePassenger::class, 'Id_BookingUpgradePassenger'),
        ];
    }

    public function __construct(
        private BookingUpgradePassengerIs23MigrationValue $is23MigrationValue,
        private BookingUpgradePassengerDate $date,
        private BookingUpgradePassengerOnlyReturn $dateOnlyReturn,
        private BookingUpgradePassengerDateEntry $dateEntry,
        private BookingUpgradePassengerDateReturn $dateReturn,
        private BookingUpgradePassengerDatePurchase $datePurchase,
        private BookingUpgradePassengerCarrier $carrier,
        private BookingUpgradePassengerCode $code,
        private BookingUpgradePassengerAmount $amount,

        private BookingUpgradePassengerRoundCarrier $roundCarrier,
        private BookingUpgradePassengerRoundCode $roundCode,
        private BookingUpgradePassengerRoundAmount $roundAmount,

        private BookingUpgradePassengerRemark $remark,
        private BookingUpgradePassengerMask $mask,
        private BookingUpgradePassengerStatus $status,
        private IdProvider $idProvider,
        private IdProvider $idProviderReturn,
        private IdAdmin $idAdmin,
        private IdBookingUpgrade $idBookingUpgrade,
        private IdBookingTourPassenger $idBookingTourPassenger,
        private ?IdBookingUpgradePassenger $id = null
    ) {
    }

    public function id(): IdBookingUpgradePassenger
    {
        return $this->id;
    }

    public function is23MigrationValue(): BookingUpgradePassengerIs23MigrationValue
    {
        return $this->is23MigrationValue;
    }

    public function date(): BookingUpgradePassengerDate
    {
        return $this->date;
    }

    public function dateOnlyReturn(): BookingUpgradePassengerOnlyReturn
    {
        return $this->dateOnlyReturn;
    }

    public function dateEntry(): BookingUpgradePassengerDateEntry
    {
        return $this->dateEntry;
    }

    public function dateReturn(): BookingUpgradePassengerDateReturn
    {
        return $this->dateReturn;
    }

    public function datePurchase(): BookingUpgradePassengerDatePurchase
    {
        return $this->datePurchase;
    }

    public function carrier(): BookingUpgradePassengerCarrier
    {
        return $this->carrier;
    }

    public function code(): BookingUpgradePassengerCode
    {
        return $this->code;
    }

    public function amount(): BookingUpgradePassengerAmount
    {
        return $this->amount;
    }

    public function roundCarrier(): BookingUpgradePassengerRoundCarrier
    {
        return $this->roundCarrier;
    }

    public function roundCode(): BookingUpgradePassengerRoundCode
    {
        return $this->roundCode;
    }

    public function roundAmount(): BookingUpgradePassengerRoundAmount
    {
        return $this->roundAmount;
    }

    public function remark(): BookingUpgradePassengerRemark
    {
        return $this->remark;
    }

    public function mask(): BookingUpgradePassengerMask
    {
        return $this->mask;
    }

    public function status(): BookingUpgradePassengerStatus
    {
        return $this->status;
    }

    public function idProvider(): IdProvider
    {
        return $this->idProvider;
    }

    public function idProviderReturn(): IdProvider
    {
        return $this->idProviderReturn;
    }

    public function idAdmin(): IdAdmin
    {
        return $this->idAdmin;
    }

    public function idBookingUpgrade(): IdBookingUpgrade
    {
        return $this->idBookingUpgrade;
    }

    public function idBookingTourPassenger(): IdBookingTourPassenger
    {
        return $this->idBookingTourPassenger;
    }
}
