<?php

namespace App\Modules\BookingUpgradePassenger\Application\Index;

use App\Modules\Shared\Domain\Bus\Query\QueryHandler;

final class IndexBookingUpgradePassengerQueryHandler implements QueryHandler
{
    public function __construct(private BookingUpgradePassengerIndexer $lister)
    {
    }

    public function __invoke(IndexBookingUpgradePassengerQuery $query): IndexBookingUpgradePassengerResponse
    {
        return new IndexBookingUpgradePassengerResponse($this->lister->__invoke($query->id()));
    }
}
