<?php

namespace App\Modules\BookingTourPassenger\Infraestructure;

use App\Modules\BookingTourPassenger\Domain\BookingTourPassenger;
use App\Modules\BookingTourPassenger\Domain\BookingTourPassengerModel;
use App\Modules\BookingTourPassenger\Domain\BookingTourPassengerRepository;
use App\Modules\BookingTourPassenger\Domain\IdBookingTourPassenger;
use App\Modules\CashMovement\Domain\IdCashMovement;
use App\Modules\Passenger\Domain\IdPassenger;
use App\Modules\Shared\Application\SelectHandler;
use App\Modules\Shared\Infraestructure\DBRequester;
use App\Modules\Shared\Infraestructure\Requester;
use Illuminate\Support\Facades\DB;

class MysqlBookingTourPassengerRepository implements BookingTourPassengerRepository
{

    public function find($criteria): BookingTourPassenger
    {
        return BookingTourPassenger::fromDTO($criteria->run());
    }

    public function search($criteria): array
    {
        return array_map(fn ($btp) => BookingTourPassenger::fromDTO($btp), $criteria->run());
    }

    public function index(IdBookingTourPassenger $idBookingTourPassenger)
    {
        return (new SelectHandler())->handle(
            DB::select(
                'CALL sp_booking_tour_passenger_index(?,?)',
                [
                    $idBookingTourPassenger->value(),
                    config('var.PATH_PUBLIC') . config('var.USER_COUNTRY_THUMB')
                ]
            )
        );
    }

    public function cancel(IdBookingTourPassenger $idBookingTourPassenger)
    {
        return Requester::requestSelect(
            'CALL sp_booking_tour_passenger_disable(?,@sts,@cod,@msg)',
            [
                $idBookingTourPassenger->value()
            ]
        );
    }

    public function update(BookingTourPassenger $bookingTourPassenger)
    {
        return Requester::requestUpdate(
            'CALL sp_booking_tour_passenger_update(?,?,?,?,?,?,?,?,?,?,@sts,@cod,@msg)',
            [
                $bookingTourPassenger->id()->value(),
                $bookingTourPassenger->reportable()->value(),
                $bookingTourPassenger->hotel()->value(),
                $bookingTourPassenger->remark()->value(),
                $bookingTourPassenger->price()->value(),
                $bookingTourPassenger->full()->value(),
                $bookingTourPassenger->validGroups()->value(),
                $bookingTourPassenger->noValidGroups()->value(),
                $bookingTourPassenger->status()->value(),
                $bookingTourPassenger->paymentStatus()->value(),
            ]
        );
    }

    public function updatePartial(BookingTourPassengerModel $value)
    {
        return DBRequester::requestUpdate($value);
    }

    public function activate(IdBookingTourPassenger $idBookingTourPassenger)
    {
        return Requester::requestSelect(
            'CALL sp_booking_tour_passenger_enable(?,@sts,@cod,@msg)',
            [
                $idBookingTourPassenger->value()
            ]
        );
    }

    public function listByPassenger(IdPassenger $idPassenger, string $action)
    {
        return Requester::requestSelect(
            'CALL sp_booking_tour_passenger_list_by_passenger(?,?,@sts,@cod,@msg)',
            [
                $idPassenger->value(),
                $action
            ]
        );
    }

    public function listByCashMovement(IdCashMovement $idCashMovement, string $action)
    {
        return Requester::requestSelect(
            'CALL sp_booking_tour_passenger_list_by_cash_movement(?,?,@sts,@cod,@msg)',
            [
                $idCashMovement->value(),
                $action
            ]
        );
    }

    public function bookingTourPassengerGroupsValidation(IdBookingTourPassenger $idBookingTourPassenger)
    {
        return Requester::requestUpdate(
            'CALL sp_internal_booking_tour_passenger_group_validation(?,@sts,@cod,@msg)',
            [
                $idBookingTourPassenger->value()
            ]
        );
    }
}
