<?php

namespace App\Modules\BookingTourPassenger\Application\UpdatePartial;

use App\Modules\BookingTourPassenger\Domain\BookingTourPassengerModel;
use App\Modules\BookingTourPassenger\Domain\BookingTourPassengerRepository;
use App\Modules\BookingTourPassenger\Domain\IdBookingTourPassenger;

final class BookingTourPassengerPartialUpdater
{
    public function __construct(
        private BookingTourPassengerRepository $repository
    ) {
    }

    public function __invoke(
        BookingTourPassengerModel $model,
    ) {
        return $this->repository->updatePartial($model);
    }
}
