<?php

namespace App\Modules\BookingTourPassenger\Application\Find;

use App\Modules\BookingTourPassenger\Domain\BookingTourPassengerRepository;
use App\Modules\BookingTourPassenger\Domain\IdBookingTourPassenger;

final class BookingTourPassengerFinder
{
    public function __construct(
        private BookingTourPassengerRepository $repository
    ) {
    }

    public function __invoke(
        IdBookingTourPassenger $id,
    ): FindBookingTourPassengerResponse {
        return new FindBookingTourPassengerResponse($this->repository->index($id));
    }
}
