<?php

namespace App\Modules\BookingExtraPassenger\Domain;

use App\Modules\Admin\Domain\IdAdmin;
use App\Modules\BookingExtra\Domain\IdBookingExtra;
use App\Modules\BookingTourPassenger\Domain\IdBookingTourPassenger;
use App\Modules\Shared\Domain\Aggregate\AggregateAttribute;
use App\Modules\Shared\Domain\Aggregate\AggregateRoot;

class BookingExtraPassenger extends AggregateRoot
{

    /** @return AgregateAttribute[] */
    protected static function attributes(): array
    {
        return [
            new AggregateAttribute('date', BookingExtraPassengerDate::class, 'BookingExtraPassenger_Date'),
            new AggregateAttribute('dateEntryStart', BookingExtraPassengerDateEntryStart::class, 'BookingExtraPassenger_DateEntryStart'),
            new AggregateAttribute('dateEntryEnd', BookingExtraPassengerDateEntryEnd::class, 'BookingExtraPassenger_DateEntryEnd'),
            new AggregateAttribute('datePurchase', BookingExtraPassengerDatePurchase::class, 'BookingExtraPassenger_DatePurchase'),
            new AggregateAttribute('code', BookingExtraPassengerCode::class, 'BookingExtraPassenger_Code'),
            new AggregateAttribute('amount', BookingExtraPassengerAmount::class, 'BookingExtraPassenger_Amount'),
            new AggregateAttribute('remark', BookingExtraPassengerRemark::class, 'BookingExtraPassenger_Remark'),
            new AggregateAttribute('status', BookingExtraPassengerStatus::class, 'BookingExtraPassenger_Status'),
            new AggregateAttribute('idAdmin', IdAdmin::class, 'Id_Admin'),
            new AggregateAttribute('idBookingExtra', IdBookingExtra::class, 'Id_BookingExtra'),
            new AggregateAttribute('idBookingTourPassenger', IdBookingTourPassenger::class, 'Id_BookingTourPassenger'),
            new AggregateAttribute('id', IdBookingExtraPassenger::class, 'Id_BookingExtraPassenger'),
        ];
    }

    public function __construct(
        private BookingExtraPassengerDate $date,
        private BookingExtraPassengerDateEntryStart $dateEntryStart,
        private BookingExtraPassengerDateEntryEnd $dateEntryEnd,
        private BookingExtraPassengerDatePurchase $datePurchase,
        private BookingExtraPassengerCode $code,
        private BookingExtraPassengerAmount $amount,
        private BookingExtraPassengerRemark $remark,
        private BookingExtraPassengerStatus $status,
        private IdAdmin $idAdmin,
        private IdBookingExtra $idBookingExtra,
        private IdBookingTourPassenger $idBookingTourPassenger,
        private ?IdBookingExtraPassenger $id = null
    ) {
    }

    public function date(): BookingExtraPassengerDate
    {
        return $this->date;
    }
    public function dateEntryStart(): BookingExtraPassengerDateEntryStart
    {
        return $this->dateEntryStart;
    }
    public function dateEntryEnd(): BookingExtraPassengerDateEntryEnd
    {
        return $this->dateEntryEnd;
    }
    public function datePurchase(): BookingExtraPassengerDatePurchase
    {
        return $this->datePurchase;
    }
    public function code(): BookingExtraPassengerCode
    {
        return $this->code;
    }
    public function amount(): BookingExtraPassengerAmount
    {
        return $this->amount;
    }
    public function remark(): BookingExtraPassengerRemark
    {
        return $this->remark;
    }
    public function status(): BookingExtraPassengerStatus
    {
        return $this->status;
    }
    public function idAdmin(): IdAdmin
    {
        return $this->idAdmin;
    }
    public function idBookingExtra(): IdBookingExtra
    {
        return $this->idBookingExtra;
    }
    public function idBookingTourPassenger(): IdBookingTourPassenger
    {
        return $this->idBookingTourPassenger;
    }
    public function id(): IdBookingExtraPassenger
    {
        return $this->id;
    }
}
