<?php

namespace App\Modules\BookingExtraPassenger\Application\Reset;

use App\Modules\BookingExtraPassenger\Domain\BookingExtraPassengerRepository;
use App\Modules\BookingExtraPassenger\Domain\IdBookingExtraPassenger;

class BookingExtraPassengerResetter
{

    private BookingExtraPassengerRepository $repository;

    public function __construct(BookingExtraPassengerRepository $repository)
    {
        $this->repository = $repository;
    }

    public function __invoke(IdBookingExtraPassenger $id)
    {
        return new ResetBookingExtraPassengerResponse($this->repository->reset($id));
    }
}
